﻿var extraction = {
    datatable: null,
    context: $(".v-extraction"),
    refreshDataTable: function () {
        extraction.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-extractionTable", extraction.context).a4datatable({
            height: "full",
            ajaxAction: a4.getProjectAction("GetTasks", "Extraction"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Data": "TaskResultMessage", "Tooltip": true },
                { "Name": "Title", "Title": resources.Name, "Data": "Title" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "DtsType", "Title": resources.DataSourceType, "Data": "DtsTypeDescription" },
                { "Name": "SourceFileName", "Title": resources.FileName, "Data": "SourceFileLabel" },
                { "Name": "TaskStatus", "Title": resources.Status, "Data": "StatusLabel", "type": "enum" },
                { "Name": "LastRunDate", "Title": resources.LastRun, "Data": "LastRunDate", "type": "date", "DefaultValue": resources.NotAvailable },
                { "Name": "CreatedOn", "Title": resources.ModifiedOn, "Data": "CreatedOn" }
            ],
            localizableTexts: { "Search": resources.SearchExtractions },
            allowRowSelection: "[ScheduleCount] == 0",
            defaultSorting: { Column: "LastRunDate", Ascending: false },
            toolBarItems: extraction.getToolBarItems(),
            stateKey: "ProjectExtraction",
            autoUpdate: true,
            contextMenuItems: extraction.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var hasSchedule = false;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);

                    if (!hasSchedule && rows[i].ScheduleCount > 0)
                    {
                        hasSchedule = true; 
                    }
                }

                switch (action) {
                    case "delete":
                        extraction.deleteTasks(ids, hasSchedule);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "stop":
                        extraction.stopTask(row.Id);
                        break;
                    case "delete":
                        extraction.deleteTasks([row.Id], row.ScheduleCount > 0);
                        break;
                    case "execute":
                        extraction.executeTask(row.Id);
                        break;
                    case "copy":
                        extraction.copyTask(row.Id, row.DtsTypeValue);
                        break;
                    case "edit":
                        extraction.editTask(row.Id, row.DtsTypeValue);
                        break;
                    case "viewExportedFiles":
                        extraction.getFiles(row.Id, row.Title);
                        break;
                    case "viewHistory":
                        extraction.viewTaskHistory(row.Id, row.Title);
                        break;
                }
            }
        });
    },
    editTask: function (itemId, dtsTypeValue) {
        window.location = a4.getProjectAction("ExtractionWizard", "Extraction", { format: dtsTypeValue, taskId: itemId });
    },
    copyTask: function (itemId, dtsTypeValue) {
        window.location = a4.getProjectAction("ExtractionWizard", "Extraction", { format: dtsTypeValue, taskId: itemId, copyTask: true });
    },
    stopTask: function (itemId) {
        a4.callServerMethod(a4.getProjectAction("StopExtraction", "Extraction"), { taskId: itemId }, function (result) {
            extraction.refreshDataTable();
        });
    },
    deleteTasks: function (items, hasSchedule) {
        if (hasSchedule)
        {
            a4.showErrorMessage(resources.DeleteTaskWarning);
        }
        else
        {
            var itemsCount = items.length;

            if (typeof itemsCount === "undefined")
                itemsCount = 1;

            modalDialog.showConfirmDelete(confirmDeleteImportationsResources, function () {
                a4.callServerMethod(a4.getProjectAction("DeleteTasks", "Extraction"), { taskIds: items },
                function (result) {
                    extraction.refreshDataTable();
                });
            }, itemsCount);
        }
    },
    executeTask: function (itemId) {
        a4.callServerMethod(a4.getProjectAction("StartExtraction", "Extraction"), { taskId: itemId }, function (result) {
            setTimeout(function () { extraction.refreshDataTable(); }, 300);
        });
    },
    getFiles: function (itemId, taskTitle) {
        modalDialog.showWindow(a4.getProjectAction("ExportedFilesBrowser", "Extraction", { taskId: itemId, taskTitle: taskTitle }), 600, 1000, { afterClose: function () { } });
    },
    viewTaskHistory: function (itemId, itemTitle) {
        modalDialog.showWindow(a4.getProjectAction("TaskHistory", "Tasks", { taskId: itemId, taskTitle: itemTitle }), 600, 1000, { afterClose: function () { } });
    },
    bindEvents: function () {
        extraction.context.on("click", ".h-copyExtractionFrom", function () {
            modalDialog.showWindow(a4.getProjectAction("CopyExtractionFrom", "Extraction"), 600, 800, { afterClose: function () { extraction.refreshDataTable(); } });
        });
    },
    getContextMenuItems: function () {
        var isNotRunning = function (data) { return data.Status != 'Running'; };
        
        return [
            { "Action": "viewHistory", "Label": resources.ViewTaskHistory, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "copy", "Label": resources.Copy },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": isNotRunning },
            { "Action": "edit", "Label": resources.Properties, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return data.Status == 'Running'; } },
            { "Action": "execute", "Label": resources.Execute, "DisplayCondition": isNotRunning },
            { "Divider": true },
            { "Action": "viewExportedFiles", "Label": resources.ExportedFilesBrowser, "DisplayCondition": function (data) { return data.Status == 'Completed'; } }
        ]
    },
    getToolBarItems: function () {
        return  [{ "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if (extraction.context.length > 0) {
        extraction.initializeDataTable();
        extraction.bindEvents();
    }
});